<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}

include ('includes/header.php');

$table_name = 'users';
$res = $db->select($table_name, '*', '', '');

if(isset($_POST['submit'])){
    unset($_POST['submit']);
    $updateData = $_POST;
    // Atualiza usuário e senha no banco (sempre id=1)
    $db->update($table_name, $updateData, 'id = :id',[':id' => 1]);

    // Atualiza sessão
    session_regenerate_id();
    $_SESSION['loggedin'] = true;
    $_SESSION['name'] = $_POST['username'];

    // Redireciona com status=1
    echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atualizar Credenciais</title>
    <style>
        :root {
            --dark-blue: #001a33;
            --primary-blue: #003366;
            --light-blue: #00AEEF;
            --gold: #FFD166;
            --success-green: #28a745;
            --danger-red: #dc3545;
            --text-light: #f8f9fa;
        }
        
        body {
            background: linear-gradient(135deg, var(--dark-blue), var(--primary-blue));
            background-attachment: fixed;
            color: var(--text-light);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }
        
        .page-container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        
        .main-content {
            flex: 1;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            padding-top: 40px;
            padding-bottom: 40px;
        }
        
        .card-custom {
            background: rgba(0, 0, 0, 0.7);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 174, 239, 0.2);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(0, 174, 239, 0.25);
            overflow: visible;
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .card-header-custom {
            background: linear-gradient(90deg, var(--dark-blue), var(--primary-blue));
            padding: 20px;
            border-bottom: 2px solid var(--light-blue);
            text-align: center;
            color: var(--gold);
        }
        
        .card-body-custom {
            padding: 30px;
        }
        
        .alert-warning {
            background-color: rgba(255, 193, 7, 0.2);
            border: 1px solid rgba(255, 193, 7, 0.3);
            color: #fff3cd;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 25px;
            text-align: center;
        }

        .alert-success {
            background-color: rgba(40, 167, 69, 0.2);
            border: 1px solid rgba(40, 167, 69, 0.3);
            color: #d4edda;
            border-radius: 8px;
            padding: 12px;
            margin-bottom: 20px;
            text-align: center;
            font-weight: bold;
        }
        
        .form-control {
            background-color: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(0, 174, 239, 0.3);
            color: white;
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s;
            height: auto;
            min-height: 45px;
            width: 100%;
            margin-bottom: 20px;
        }
        
        .form-control:focus {
            background-color: rgba(255, 255, 255, 0.15);
            border-color: var(--light-blue);
            box-shadow: 0 0 0 0.2rem rgba(0, 174, 239, 0.25);
            color: white;
        }
        
        .form-label {
            font-weight: 600;
            color: var(--text-light);
            margin-bottom: 8px;
            display: block;
            font-size: 1.1em;
        }
        
        .btn-custom {
            background: linear-gradient(45deg, var(--dark-blue), var(--primary-blue));
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: bold;
            color: white;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(0, 174, 239, 0.25);
            margin-top: 15px;
        }
        
        .btn-custom:hover {
            background: linear-gradient(45deg, var(--primary-blue), var(--light-blue));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 174, 239, 0.35);
        }
        
        h2, h3 {
            font-weight: 700;
            text-shadow: 0 0 6px rgba(0,0,0,0.6);
        }
        
        .emoji {
            font-size: 1.2em;
            margin-right: 8px;
        }
        
        .divider {
            height: 1px;
            background: linear-gradient(90deg, transparent, var(--light-blue), transparent);
            margin: 25px 0;
            border: none;
        }
    </style>
</head>
<body>
<div class="page-container">
    <div class="main-content">
        <div class="card-custom">
            <div class="card-header-custom">
                <h2><span class="emoji">👤</span> Atualizar Credenciais</h2>
            </div>
            
            <div class="card-body-custom">
                <?php if (isset($_GET['status']) && $_GET['status'] == 1): ?>
                    <div class="alert-success">
                        ✅ Credenciais atualizadas com sucesso!
                    </div>
                <?php endif; ?>

                <div class="alert-warning">
                    ⚠️ Não use <strong>admin</strong> para nome de usuário ou senha!
                </div>

                <form method="post">
                    <div class="form-group">
                        <label class="form-label"><span class="emoji">🔑</span> Nome de Usuário</label>
                        <input type="text" class="form-control" name="username" value="<?=$res[0]['username'] ?>" required>
                    </div>

                    <div class="form-group">
                        <label class="form-label"><span class="emoji">🔒</span> Senha</label>
                        <input type="text" class="form-control" name="password" value="<?=$res[0]['password'] ?>" required>
                    </div>

                    <hr class="divider">

                    <center>
                        <button type="submit" name="submit" class="btn btn-custom">
                            <span class="emoji">💾</span> Atualizar Credenciais
                        </button>
                    </center>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include ('includes/footer.php'); ?>
</body>
</html>
