<?php
// Este é um exemplo de como o código PHP pode ser estruturado.
// Certifique-se de que 'includes/functions.php' e a lógica de banco de dados
// estejam configurados corretamente no seu ambiente.

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Inclua seu arquivo de funções e conexão com o banco de dados aqui
// include('includes/functions.php'); // Descomente e ajuste conforme necessário

// Exemplo de funções dummy se o include acima não for usado para evitar erros
if (!function_exists('normalise_mac')) {
    function normalise_mac(string $raw): string {
        $raw = strtolower(trim($raw));
        $hex = preg_replace('/[^0-9a-f]/', '', $raw);
        $pairs = array_filter(str_split($hex, 2), static fn($p) => strlen($p) === 2);
        return implode(':', $pairs);
    }
}

// Variáveis de exemplo para simular o ambiente PHP
$table_name = "playlist";
$dnss = []; // Preencha com dados reais do seu banco de dados
$response = null;
$prefilled_mac = ''; // Preencha com dados reais se houver MAC pré-preenchido

// Lógica de processamento do formulário (simplificada para este exemplo)
if (isset($_POST['submit'])) {
    // ... sua lógica de processamento do formulário aqui ...
    $response = [
        "status" => "ok",
        "message" => "Dados processados com sucesso!",
        "data" => []
    ];
}

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Ativar MAC</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- Adicionado para responsividade -->
    <link rel="icon" href="img/favicons/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            margin: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: sans-serif;
            background: radial-gradient(circle at center, #001a33, #000814 80%);
            overflow: hidden;
            color: #fff;
        }

        /* Canvas de partículas */
        #particles {
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            z-index: 0;
        }


        .box {
            position: relative;
            z-index: 1;
            width: 90%;
            max-width: 420px; /* bloco maior, mudança horizontal*/
            background: rgba(0, 43, 85, 0.9);
            padding: 50px 40px;
            border-radius: 18px;
            box-shadow: 0 0 30px rgba(0, 174, 239, 0.6);
            text-align: center;
            backdrop-filter: blur(6px);
        }

        .box img {
            max-width: 150px; /* bloco, mudança vertical*/
            margin: 0 auto 30px auto;
            display: block;
            filter: drop-shadow(0 0 12px #00aeef);
        }

        input {
            width: 100%;
            max-width: 350px;
            font-size: 25px;       /* texto grande */
            letter-spacing: 1px;   /* espaçamento entre caracteres */
            text-align: center;
            padding: 10px 12px;    /* altura proporcional */
            border: none;
            border-radius: 10px;
            margin: 20px auto;
            display: block;
            background-color: #003366;
            color: #fff;
            border: 2px solid #00aeef;
            box-shadow: inset 0 0 8px rgba(0,174,239,0.4);
            box-sizing: border-box; /* Adicionado para garantir que padding não aumente a largura */
        }

        input::placeholder {
            color: #bbb;
        }

        button {
            margin-top: 15px;
            padding: 18px;
            border: none;
            border-radius: 10px;
            background: linear-gradient(90deg, #00aeef, #007bbd);
            color: #fff;
            font-weight: bold;
            cursor: pointer;
            width: 100%;
            max-width: 350px;
            font-size: 22px;
            box-shadow: 0 0 18px rgba(0,174,239,0.7);
            transition: all 0.3s ease-in-out;
            box-sizing: border-box; /* Adicionado para garantir que padding não aumente a largura */
        }

        button:hover {
            background: linear-gradient(90deg, #007bbd, #00aeef);
            transform: scale(1.05);
            box-shadow: 0 0 28px rgba(0,174,239,1);
        }

        /* Celulares */
        @media (max-width: 968px) {
            body {
                padding: 0;
                align-items: center;
            }

            .box {
                width: 90vw; /* Ocupa 100% da largura da viewport */
                height: 60vh; /* Ocupa 100% da altura da viewport */
                max-width: none;
                padding: 25px 10px;
                border-radius: 21; /* Remove bordas arredondadas para ocupar a tela toda */
                box-shadow: none; /* Remove sombra */
                display: flex; /* Para centralizar conteúdo verticalmente */
                flex-direction: column;
                justify-content: center;
            }

            input#mac {
                width: calc(100% - 20px); /* Ocupa a largura total menos o padding do .box */
                max-width: none; /* Remove a limitação de largura */
                font-size: 21px;          /* texto bem grande */
                letter-spacing: 1px;      /* espaçamento entre pares */
                padding: 18px 12px;       /* campo bem alto */
                margin: 15px auto; /* Centraliza horizontalmente */
                box-sizing: border-box;
            }

            button {
                font-size: 26px;
                padding: 22px;
                width: calc(100% - 20px); /* Ocupa a largura total menos o padding do .box */
                max-width: none; /* Remove a limitação de largura */
                margin: 15px auto; /* Centraliza horizontalmente */
            }

            .box img {
                max-width: 180px; /* Ajusta o tamanho da logo para mobile */
                margin: 0 auto 20px auto;
                display: block;
            }
        }

    </style>
</head>
<body>
<canvas id="particles"></canvas>

<div class="box">
    <img src="img/logo.png" alt="Logo">
    <form action="newmac.php" method="get">
        <input type="text" name="mac" id="mac"
               placeholder="Insira o MAC aqui!"
               maxlength="23" required>
        <button type="submit">🚀 ATIVAR</button>
    </form>
</div>

<script>
// Formata MAC enquanto digita (para 8 pares)
document.getElementById("mac").addEventListener("input", function() {
    let value = this.value.toUpperCase().replace(/[^0-9A-F]/g, "");
    
    // Limita a 16 caracteres (8 pares)
    if (value.length > 16) {
        value = value.substring(0, 16);
    }
    
    // Adiciona os dois pontos entre os pares
    const pairs = value.match(/.{1,2}/g) || [];
    this.value = pairs.join(":");
});

// Animação de partículas
const canvas = document.getElementById("particles");
const ctx = canvas.getContext("2d");
canvas.width = window.innerWidth;
canvas.height = window.innerHeight;

let particles = [];
const colors = ["#00aeef", "#FFD166", "#ffffff"];

function createParticles() {
    for (let i = 0; i < 120; i++) {
        particles.push({
            x: Math.random() * canvas.width,
            y: Math.random() * canvas.height,
            speed: 3 + Math.random() * 5,
            size: Math.random() * 2.2,
            color: colors[Math.floor(Math.random() * colors.length)]
        });
    }
}

function animate() {
    ctx.fillStyle = "rgba(0, 0, 0, 0.25)";
    ctx.fillRect(0, 0, canvas.width, canvas.height);

    particles.forEach(p => {
        ctx.beginPath();
        ctx.arc(p.x, p.y, p.size, 0, Math.PI * 2);
        ctx.fillStyle = p.color;
        ctx.fill();

        p.y -= p.speed;
        if (p.y < 0) {
            p.y = canvas.height;
            p.x = Math.random() * canvas.width;
        }
    });

    requestAnimationFrame(animate);
}

createParticles();
animate();

window.addEventListener("resize", () => {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
});
</script>
</body>
</html>



