<?php
session_start();
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>9x 4K by P2PLAY</title>
  <meta name="theme-color" content="#0a0f2b">

  <!-- Favicons -->
  <link rel="apple-touch-icon" sizes="180x180" href="./img/favicons/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="./img/favicons/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="./img/favicons/favicon-16x16.png">
  <link rel="manifest" href="./img/favicons/site.webmanifest">
  <link rel="shortcut icon" href="./img/favicons/favicon.ico">

  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">

  <style>
    body {
      margin: 0;
      height: 100vh;
      overflow: hidden;
      background: #0a0f2b;
      color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
      flex-direction: column;
    }

    #particles-js {
      position: fixed;
      inset: 0;
      z-index: 0;
    }
    .particles-js-canvas-el {
      pointer-events: none !important;
    }

    .content {
      position: relative;
      z-index: 1;
      text-align: center;
    }

    .logo {
      width: 180px;
      margin-bottom: 30px;
    }

    .btn-login {
      font-size: 1.2rem;
      font-weight: 700;
      padding: 12px 40px;
      border-radius: 50px;
      border: none;
      cursor: pointer;
      background: linear-gradient(45deg, #FFD166, #00AEEF);
      color: #0a0f2b;
      box-shadow: 0 8px 20px rgba(0,0,0,0.35);
      transition: transform 0.2s ease, box-shadow 0.3s ease;
    }
    .btn-login:hover {
      transform: translateY(-3px);
      box-shadow: 0 12px 28px rgba(0,0,0,0.45);
    }

    footer {
      margin-top: 40px;
      font-size: 0.9rem;
      opacity: 0.7;
    }
  </style>
</head>
<body>
  <div id="particles-js"></div>

  <div class="content">
    <img src="./img/logo.png" alt="9x 4K by P2PLAY" class="logo">
    <br>
    <a href="login.php" class="btn-login">Entrar no Painel</a>
    <footer>
      © <?=date("Y")?> • 9x 4K by P2PLAY
    </footer>
  </div>

  <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
  <script>
    /* Partículas com efeito de surgimento ao arrastar */
    particlesJS('particles-js', {
      "particles": {
        "number": { "value": 40, "density": { "enable": true, "value_area": 1000 } },
        "color": { "value": ["#FFD166", "#00AEEF"] },
        "shape": { "type": "circle" },
        "opacity": { "value": 0.4, "random": true },
        "size": { "value": 3, "random": true },
        "line_linked": { "enable": true, "distance": 120, "color": "#ffffff", "opacity": 0.15, "width": 1 },
        "move": { "enable": true, "speed": 2, "direction": "none", "random": false, "straight": false, "out_mode": "out" }
      },
      "interactivity": {
        "detect_on": "canvas",
        "events": {
          "onhover": { "enable": true, "mode": "repulse" },
          "onclick": { "enable": true, "mode": "push" },
          "resize": true
        },
        "modes": {
          "repulse": { "distance": 120, "duration": 0.4 },
          "push": { "particles_nb": 6 } // partículas extras ao clicar/arrastar
        }
      },
      "retina_detect": true
    });

    /* Partículas extras enquanto arrasta o mouse */
    let isDragging = false;
    document.addEventListener("mousedown", ()=>{ isDragging = true; });
    document.addEventListener("mouseup", ()=>{ isDragging = false; });
    document.addEventListener("mousemove", (e)=>{
      if(isDragging && window.pJSDom && pJSDom[0]){
        for(let i=0;i<2;i++){ // quantidade de partículas por movimento
          pJSDom[0].pJS.particles.array.push(
            new pJSDom[0].pJS.fn.particle(pJSDom[0].pJS.particles.color, pJSDom[0].pJS.particles.opacity.value, {x: e.clientX, y: e.clientY})
          );
        }
      }
    });
  </script>
</body>
</html>


