// js/particles.js
(function () {
  // Usa o mesmo ID que está no seu layout
  var containerId = document.getElementById('js-particles') ? 'js-particles' : 'particles-js';
  if (!window.particlesJS || !document.getElementById(containerId)) return;

  particlesJS(containerId, {
    particles: {
      number: { value: 120, density: { enable: true, value_area: 900 } },
      color: { value: ["#00AEEF", "#FFD166", "#FFFFFF"] }, // azul + dourado + branco
      shape: { type: "circle" },
      opacity: { value: 0.7, random: true },
      size: { value: 3, random: true },
      line_linked: { enable: true, distance: 130, color: "#99bbff", opacity: 0.35, width: 1 },
      move: {
        enable: true,
        speed: 1.8,          // movimento mais rápido
        direction: "none",
        random: false,
        straight: false,
        out_mode: "out",
        bounce: false
      }
    },
    interactivity: {
      detect_on: "canvas",
      events: {
        onhover: { enable: true, mode: "repulse" }, // foge do mouse
        onclick: { enable: true, mode: "push" },
        resize: true
      },
      modes: {
        repulse: { 
          distance: 250,   // aumenta alcance da fuga
          duration: 1.0    // duração mais longa → efeito visível
        },
        push: { particles_nb: 4 },
        grab: { distance: 160, line_linked: { opacity: 0.45 } }
      }
    },
    retina_detect: true
  });
})();

