-- Script SQL para criação das tabelas necessárias
-- Execute este script no seu banco de dados MySQL

-- Criação da tabela DNS (servidores)
CREATE TABLE IF NOT EXISTS `dns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL COMMENT 'Nome do servidor DNS',
  `url` varchar(500) NOT NULL COMMENT 'URL do servidor',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Criação da tabela playlist (usuários/listas)
CREATE TABLE IF NOT EXISTS `playlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dns_id` int(11) NOT NULL COMMENT 'ID do servidor DNS',
  `mac_address` varchar(17) NOT NULL COMMENT 'Endereço MAC do dispositivo',
  `username` varchar(255) NOT NULL COMMENT 'Nome de usuário',
  `password` varchar(255) NOT NULL COMMENT 'Senha do usuário',
  `pin` varchar(4) NOT NULL DEFAULT '0000' COMMENT 'PIN parental',
  `link` text COMMENT 'Link da lista M3U',
  `device_key` varchar(8) NOT NULL COMMENT 'Chave do dispositivo',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mac_address` (`mac_address`),
  KEY `dns_id` (`dns_id`),
  KEY `username` (`username`),
  KEY `device_key` (`device_key`),
  CONSTRAINT `playlist_dns_fk` FOREIGN KEY (`dns_id`) REFERENCES `dns` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserção de dados de exemplo para DNS (opcional)
INSERT INTO `dns` (`title`, `url`) VALUES
('Servidor Principal', 'http://servidor1.exemplo.com:8080'),
('Servidor Backup', 'http://servidor2.exemplo.com:8080'),
('Servidor Local', 'http://192.168.1.100:8080')
ON DUPLICATE KEY UPDATE `url` = VALUES(`url`);

-- Criação de índices adicionais para performance
CREATE INDEX `idx_playlist_created` ON `playlist` (`created_at`);
CREATE INDEX `idx_playlist_mac_dns` ON `playlist` (`mac_address`, `dns_id`);

-- Criação da tabela de logs (opcional - para auditoria)
CREATE TABLE IF NOT EXISTS `activity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(45) NOT NULL COMMENT 'IP do usuário',
  `action` varchar(100) NOT NULL COMMENT 'Ação realizada',
  `data` json COMMENT 'Dados da ação em JSON',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_logs_ip` (`ip_address`),
  KEY `idx_logs_action` (`action`),
  KEY `idx_logs_created` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Comentários das tabelas
ALTER TABLE `dns` COMMENT = 'Tabela de servidores DNS/IPTV';
ALTER TABLE `playlist` COMMENT = 'Tabela de usuários e listas IPTV';
ALTER TABLE `activity_logs` COMMENT = 'Logs de atividade do painel externo';

-- Verificação das tabelas criadas
SHOW TABLES LIKE 'dns';
SHOW TABLES LIKE 'playlist';
SHOW TABLES LIKE 'activity_logs';

-- Exibir estrutura das tabelas
DESCRIBE `dns`;
DESCRIBE `playlist`;
DESCRIBE `activity_logs`;

