<?php
/**
 * Arquivo de Configuração do Painel Externo
 * 
 * INSTRUÇÕES DE INSTALAÇÃO:
 * 1. Edite as configurações abaixo conforme seu ambiente
 * 2. Certifique-se de que o banco de dados existe e as tabelas estão criadas
 * 3. Faça upload dos arquivos para seu servidor web
 * 4. Acesse o painel através do navegador
 */

// ===== CONFIGURAÇÕES DO BANCO DE DADOS =====
define('DB_HOST', 'localhost');           // Endereço do servidor MySQL
define('DB_NAME', 'seu_banco_de_dados');  // Nome do banco de dados
define('DB_USER', 'seu_usuario');         // Usuário do banco de dados
define('DB_PASS', 'sua_senha');           // Senha do banco de dados
define('DB_CHARSET', 'utf8');             // Charset do banco de dados

// ===== CONFIGURAÇÕES DE SEGURANÇA =====
// Defina uma chave secreta para maior segurança (opcional)
define('SECRET_KEY', 'sua_chave_secreta_aqui');

// Limitar acesso por IP (opcional - deixe vazio para permitir todos)
// Exemplo: ['192.168.1.100', '10.0.0.50']
$allowed_ips = [];

// ===== CONFIGURAÇÕES GERAIS =====
// Nome do painel (aparece no título)
define('PANEL_TITLE', 'Painel Externo - Adicionar Lista');

// Tabela onde os usuários serão inseridos
define('USERS_TABLE', 'playlist');

// Tabela de DNS
define('DNS_TABLE', 'dns');

// ===== VALIDAÇÃO DE ACESSO POR IP =====
if (!empty($allowed_ips)) {
    $client_ip = $_SERVER['REMOTE_ADDR'] ?? '';
    
    // Verificar se está atrás de proxy
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $client_ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } elseif (!empty($_SERVER['HTTP_X_REAL_IP'])) {
        $client_ip = $_SERVER['HTTP_X_REAL_IP'];
    }
    
    if (!in_array(trim($client_ip), $allowed_ips)) {
        http_response_code(403);
        die('Acesso negado. IP não autorizado.');
    }
}

// ===== FUNÇÃO DE CONEXÃO COM BANCO =====
function getDbConnection() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $pdo = new PDO($dsn, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        return $pdo;
    } catch(PDOException $e) {
        error_log("Erro de conexão com banco: " . $e->getMessage());
        die("Erro de conexão com o banco de dados. Verifique as configurações.");
    }
}

// ===== LOGS DE ATIVIDADE =====
function logActivity($action, $data = []) {
    $log_entry = [
        'timestamp' => date('Y-m-d H:i:s'),
        'ip' => $_SERVER['REMOTE_ADDR'] ?? 'unknown',
        'action' => $action,
        'data' => $data
    ];
    
    // Salvar em arquivo de log (opcional)
    $log_file = __DIR__ . '/logs/activity.log';
    if (is_dir(dirname($log_file)) || mkdir(dirname($log_file), 0755, true)) {
        file_put_contents($log_file, json_encode($log_entry) . "\n", FILE_APPEND | LOCK_EX);
    }
}
?>

