# Painel Externo - Inserção de Listas sem Login

Este painel permite adicionar novos usuários/listas ao sistema sem necessidade de autenticação, ideal para uso externo ou por terceiros.

## 📋 Características

- ✅ **Sem necessidade de login** - Acesso direto ao formulário
- ✅ **Interface responsiva** - Funciona em desktop e mobile
- ✅ **Validação automática** - Formatação de MAC address e validação de campos
- ✅ **Extração automática** - Preenche campos a partir de URL M3U
- ✅ **Logs de atividade** - Registra todas as ações para auditoria
- ✅ **Configuração flexível** - Arquivo de configuração separado
- ✅ **Segurança** - Validação de dados e proteção contra duplicatas

## 📁 Arquivos Incluídos

- `painel_externo.php` - Versão básica do painel
- `painel_externo_v2.php` - Versão avançada com mais recursos
- `config.php` - Arquivo de configuração
- `database.sql` - Script para criação das tabelas
- `README.md` - Este arquivo de instruções

## 🚀 Instalação

### 1. Requisitos

- Servidor web com PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Extensões PHP: PDO, PDO_MySQL

### 2. Configuração do Banco de Dados

Execute o script SQL para criar as tabelas necessárias:

```sql
-- Veja o arquivo database.sql para o script completo
```

### 3. Configuração dos Arquivos

1. **Edite o arquivo `config.php`:**
   ```php
   define('DB_HOST', 'localhost');           // Seu servidor MySQL
   define('DB_NAME', 'seu_banco_de_dados');  // Nome do seu banco
   define('DB_USER', 'seu_usuario');         // Usuário do banco
   define('DB_PASS', 'sua_senha');           // Senha do banco
   ```

2. **Configure permissões de pasta (opcional):**
   ```bash
   mkdir logs
   chmod 755 logs
   ```

### 4. Upload dos Arquivos

Faça upload dos arquivos para seu servidor web:
- `painel_externo_v2.php` (recomendado)
- `config.php`

### 5. Teste de Acesso

Acesse o painel através do navegador:
```
http://seudominio.com/painel_externo_v2.php
```

## 🎯 Como Usar

### Adicionando um Usuário Manualmente

1. Acesse o painel
2. Preencha os campos obrigatórios:
   - **DNS**: Selecione o servidor DNS
   - **MAC Address**: Digite o endereço MAC (será formatado automaticamente)
   - **Usuário**: Nome de usuário
   - **Senha**: Senha do usuário
   - **PIN**: PIN parental (4 dígitos)
3. Clique em "Adicionar Lista"

### Usando a Extração Automática

1. Cole uma URL M3U no campo "Lista M3U / URL Xtream"
   ```
   Exemplo: http://servidor.com:8080/get.php?username=teste&password=123456&type=m3u
   ```
2. Clique em "Extrair"
3. Os campos usuário e senha serão preenchidos automaticamente
4. Complete os demais campos e envie

## 🔧 Configurações Avançadas

### Limitação de Acesso por IP

No arquivo `config.php`, configure IPs permitidos:

```php
$allowed_ips = ['192.168.1.100', '10.0.0.50'];
```

### Personalização do Título

```php
define('PANEL_TITLE', 'Seu Título Personalizado');
```

### Logs de Atividade

Os logs são salvos automaticamente em `logs/activity.log` e incluem:
- Timestamp da ação
- IP do usuário
- Dados inseridos
- Erros ocorridos

## 🛡️ Segurança

### Medidas Implementadas

- ✅ Validação de dados de entrada
- ✅ Proteção contra SQL Injection (prepared statements)
- ✅ Verificação de MAC address duplicado
- ✅ Sanitização de dados de saída (XSS protection)
- ✅ Logs de auditoria
- ✅ Limitação de acesso por IP (opcional)

### Recomendações Adicionais

1. **Use HTTPS** em produção
2. **Configure firewall** para limitar acesso
3. **Monitore os logs** regularmente
4. **Faça backup** do banco de dados
5. **Mantenha o PHP atualizado**

## 🔍 Solução de Problemas

### Erro de Conexão com Banco

```
Erro de conexão com o banco de dados. Verifique as configurações.
```

**Solução:**
1. Verifique as credenciais em `config.php`
2. Confirme que o banco de dados existe
3. Teste a conexão manualmente

### Erro "MAC já cadastrado"

```
Este endereço MAC já está cadastrado
```

**Solução:**
1. Verifique se o MAC realmente existe no banco
2. Use um MAC diferente
3. Remova o registro duplicado se necessário

### Campos não preenchidos na extração

**Solução:**
1. Verifique se a URL está no formato correto
2. Confirme que a URL contém os parâmetros `username` e `password`
3. Teste a URL em um navegador

## 📊 Estrutura do Banco de Dados

### Tabela `playlist`
- `id` - ID único (auto increment)
- `dns_id` - ID do servidor DNS
- `mac_address` - Endereço MAC do dispositivo
- `username` - Nome de usuário
- `password` - Senha
- `pin` - PIN parental
- `link` - Link da lista
- `device_key` - Chave do dispositivo
- `created_at` - Data de criação

### Tabela `dns`
- `id` - ID único
- `title` - Nome do servidor
- `url` - URL do servidor

## 📞 Suporte

Para dúvidas ou problemas:

1. Verifique este README
2. Consulte os logs de erro
3. Teste em ambiente local primeiro
4. Verifique as configurações do servidor

## 📝 Changelog

### Versão 2.0
- ✅ Arquivo de configuração separado
- ✅ Validação aprimorada
- ✅ Logs de atividade
- ✅ Interface melhorada
- ✅ Proteção contra duplicatas
- ✅ Limitação de acesso por IP

### Versão 1.0
- ✅ Funcionalidade básica
- ✅ Formulário de inserção
- ✅ Extração de URL M3U
- ✅ Formatação automática de MAC

---

**Desenvolvido para integração com sistemas de gerenciamento de usuários IPTV/Streaming**

