<?php
session_start();

// Redireciona se não estiver autenticado
if (!isset($_SESSION["authenticated"]) || $_SESSION["authenticated"] !== true) {
    header("Location: index.php");
    exit();
}

$username = "admin";
$password = "admin";
$resetSuccess = false;
$errorMessage = "";
$resetPanelAddress = "";

// Define o diretório raiz do servidor web. Ajuste conforme a sua configuração.
// Geralmente, para um script em /7resetsenha/resetsenha.php, o diretório raiz seria o pai de 7resetsenha.
$webRoot = realpath(__DIR__ . "/../.."); // Assumindo que o script resetsenha.php está dentro de 7resetsenha, e 7resetsenha está diretamente sob o web root

$available_panels = [];

// Escaneia o diretório raiz para encontrar subdiretórios
$directories = array_filter(glob($webRoot . 
'/*', GLOB_ONLYDIR), 'is_dir');

foreach ($directories as $dir) {
    $panelName = basename($dir);
    // Verifica se o diretório contém o arquivo api/.db.db
    if (file_exists($dir . "/api/.db.db")) {
        $available_panels[] = $panelName;
    }
}

// Ordena os painéis encontrados alfabeticamente
sort($available_panels);

if (isset($_POST["reset_panel"])) {
    $panelToReset = $_POST["reset_panel"];
    $databaseFile = $webRoot . "/" . $panelToReset . "/api/.db.db"; // Caminho real para o arquivo do banco de dados
    $resetPanelAddress = (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] === "on" ? "https" : "http") . "://" . $_SERVER["HTTP_HOST"] . "/" . $panelToReset;

    try {
        // Verifica se o arquivo do banco de dados existe antes de tentar conectar
        if (!file_exists($databaseFile)) {
            throw new Exception("Arquivo de banco de dados não encontrado para o painel: " . $panelToReset);
        }

        $db = new PDO("sqlite:" . $databaseFile);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Delete all existing users
        $db->exec("DELETE FROM users;");

        // Insert new admin user with password 'admin'
        $db->exec("INSERT INTO users (username, password) VALUES (" . $db->quote($username) . ", " . $db->quote($password) . ");");

        $resetSuccess = true;
    } catch (PDOException $e) {
        $errorMessage = "Erro ao redefinir utilizador e senha para " . $panelToReset . ": " . $e->getMessage();
    } catch (Exception $e) {
        $errorMessage = $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset de Senha</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #1a1a1a;
            color: #f0f0f0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }
        .container {
            background-color: #2a2a2a;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.5);
            text-align: center;
            width: 100%;
            max-width: 600px; /* Aumentado para acomodar mais conteúdo */
        }
        h1 {
            color: #e0e0e0;
            margin-bottom: 20px;
        }
        .message {
            margin-bottom: 20px;
            font-size: 1.1em;
        }
        .success {
            color: #4CAF50;
        }
        .error {
            color: #ff6b6b;
        }
        .credentials {
            background-color: #3a3a3a;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            text-align: left;
            word-break: break-all;
        }
        .credentials p {
            margin: 5px 0;
        }
        .panel-list {
            margin-top: 20px;
            text-align: left;
        }
        .panel-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #3a3a3a;
            padding: 10px 15px;
            border-radius: 5px;
            margin-bottom: 10px;
        }
        .panel-item span {
            font-size: 1.1em;
            color: #e0e0e0;
        }
        .buttons button {
            background-color: #007bff;
            color: white;
            padding: 12px 20px;
            border: none;
            border-radius: 25px;
            cursor: pointer;
            font-size: 16px;
            margin: 8px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 8px rgba(0, 123, 255, 0.3);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .buttons button:hover {
            background-color: #0056b3;
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 123, 255, 0.4);
        }
        .buttons button.whatsapp {
            background-color: #25D366;
            box-shadow: 0 4px 8px rgba(37, 211, 102, 0.3);
        }
        .buttons button.whatsapp:hover {
            background-color: #1DA851;
            box-shadow: 0 6px 12px rgba(37, 211, 102, 0.4);
        }
        .buttons button.reset {
            background-color: #dc3545;
            box-shadow: 0 4px 8px rgba(220, 53, 69, 0.3);
        }
        .buttons button.reset:hover {
            background-color: #c82333;
            box-shadow: 0 6px 12px rgba(220, 53, 69, 0.4);
        }
        .logout-btn {
            background-color: #6c757d;
            margin-top: 20px;
            box-shadow: 0 4px 8px rgba(108, 117, 125, 0.3);
        }
        .logout-btn:hover {
            background-color: #5a6268;
            box-shadow: 0 6px 12px rgba(108, 117, 125, 0.4);
        }

        /* Estilos para o Modal */
        .modal-overlay {
            display: none; /* Escondido por padrão */
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }
        .modal-content {
            background-color: #2a2a2a;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.8);
            text-align: center;
            max-width: 400px;
            width: 90%;
            position: relative;
        }
        .modal-content h2 {
            color: #e0e0e0;
            margin-bottom: 15px;
        }
        .modal-content p {
            color: #f0f0f0;
            margin-bottom: 20px;
        }
        .modal-buttons button {
            padding: 10px 20px;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-size: 1em;
            margin: 0 10px;
            transition: background-color 0.3s ease;
        }
        .modal-buttons button.confirm-btn {
            background-color: #dc3545;
            color: white;
        }
        .modal-buttons button.confirm-btn:hover {
            background-color: #c82333;
        }
        .modal-buttons button.cancel-btn {
            background-color: #6c757d;
            color: white;
        }
        .modal-buttons button.cancel-btn:hover {
            background-color: #5a6268;
        }
        .modal-buttons button.ok-btn {
            background-color: #007bff;
            color: white;
        }
        .modal-buttons button.ok-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <!-- Modal de Confirmação -->
    <div id="confirmationModal" class="modal-overlay">
        <div class="modal-content">
            <h2 id="confirmationTitle">Confirmar Ação</h2>
            <p id="confirmationMessage">Você tem certeza que deseja realizar esta ação?</p>
            <div class="modal-buttons">
                <button class="confirm-btn" id="confirmButton">Confirmar</button>
                <button class="cancel-btn" id="cancelButton">Cancelar</button>
            </div>
        </div>
    </div>

    <!-- Modal de Mensagem (Sucesso/Erro) -->
    <div id="messageModal" class="modal-overlay">
        <div class="modal-content">
            <h2 id="messageTitle"></h2>
            <p id="messageText"></p>
            <div class="modal-buttons">
                <button class="ok-btn" id="okButton">OK</button>
            </div>
        </div>
    </div>
    <div class="container">
        <h1>Reset de Senha</h1>
        <?php if ($resetSuccess): ?>
            <p class="message success">Senha resetada com sucesso para o painel: <strong><?php echo htmlspecialchars($resetPanelAddress); ?></strong></p>
            <div class="credentials">
                <p><strong>Endereço do Painel:</strong> <span id="panelAddress"><?php echo htmlspecialchars($resetPanelAddress); ?></span></p>
                <p><strong>Usuário:</strong> <span id="username"><?php echo htmlspecialchars($username); ?></span></p>
                <p><strong>Senha:</strong> <span id="password"><?php echo htmlspecialchars($password); ?></span></p>
            </div>
            <div class="buttons">
                <button onclick="copyCredentials()">Copiar Credenciais</button>
                <button class="whatsapp" onclick="sendToWhatsApp()">Enviar via WhatsApp</button>
            </div>
        <?php elseif ($errorMessage): ?>
            <p class="message error"><?php echo htmlspecialchars($errorMessage); ?></p>
        <?php else: ?>
            <p class="message">Selecione um painel para redefinir o usuário e a senha para 'admin'/'admin'.</p>
            <div class="panel-list">
                <?php foreach ($available_panels as $panel): ?>
                    <div class="panel-item">
                        <span><?php echo htmlspecialchars($panel); ?></span>
        <form method="POST" style="margin: 0;" id="resetForm-<?php echo htmlspecialchars($panel); ?>">
                            <input type="hidden" name="reset_panel" value="<?php echo htmlspecialchars($panel); ?>">
                            <button type="button" class="reset" onclick="showConfirmationModal(\'<?php echo htmlspecialchars($panel); ?>\')">Resetar Senha</button>
                        </form>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <form action="index.php" method="GET">
            <button type="submit" name="logout" class="logout-btn">Sair</button>
        </form>
    </div>

    <script>
        const confirmationModal = document.getElementById(\'confirmationModal\');
        const messageModal = document.getElementById(\'messageModal\');
        const confirmButton = document.getElementById(\'confirmButton\');
        const cancelButton = document.getElementById(\'cancelButton\');
        const okButton = document.getElementById(\'okButton\');
        let panelToResetGlobal = \'\';

        function showConfirmationModal(panelName) {
            panelToResetGlobal = panelName;
            document.getElementById(\'confirmationMessage\').innerText = `Tem certeza que deseja redefinir a senha para o painel: ${panelName}?`;
            confirmationModal.style.display = \'flex\';
        }

        confirmButton.onclick = function() {
            confirmationModal.style.display = \'none\';
            document.getElementById(`resetForm-${panelToResetGlobal}`).submit();
        };

        cancelButton.onclick = function() {
            confirmationModal.style.display = \'none\';
        };

        function showMessageModal(title, text, type) {
            document.getElementById(\'messageTitle\').innerText = title;
            document.getElementById(\'messageText\').innerText = text;
            messageModal.style.display = \'flex\';
        }

        okButton.onclick = function() {
            messageModal.style.display = \'none\';
        };

        function copyCredentials() {
            const panelAddress = document.getElementById(\'panelAddress\').innerText;
            const username = document.getElementById(\'username\').innerText;
            const password = document.getElementById(\'password\').innerText;
            const textToCopy = `Endereço do Painel: ${panelAddress}\nUsuário: ${username}\nSenha: ${password}`;
            navigator.clipboard.writeText(textToCopy).then(() => {
                showMessageModal(\'Sucesso!\', \'Credenciais copiadas para a área de transferência!\', \'success\');
            }).catch(err => {
                console.error(\'Erro ao copiar: \', err);
                showMessageModal(\'Erro!\', \'Erro ao copiar credenciais.\', \'error\');
            });
        }

        function sendToWhatsApp() {
            const panelAddress = document.getElementById(\'panelAddress\').innerText;
            const username = document.getElementById(\'username\').innerText;
            const password = document.getElementById(\'password\').innerText;
            const message = `Olá! Suas novas credenciais de acesso são:\n\nEndereço do Painel: ${panelAddress}\nUsuário: ${username}\nSenha: ${password}\n\nPor favor, guarde-as em segurança.`
            const whatsappUrl = `https://api.whatsapp.com/send?text=${encodeURIComponent(message)}`;
            window.open(whatsappUrl, \'_blank\');
        }

        <?php if ($resetSuccess): ?>
            window.onload = function() {
                showMessageModal(\'Sucesso!\', \'Senha resetada com sucesso para o painel: <?php echo htmlspecialchars($resetPanelAddress); ?>\', \'success\');
            };
        <?php elseif ($errorMessage): ?>
            window.onload = function() {
                showMessageModal(\'Erro!\', \'<?php echo htmlspecialchars($errorMessage); ?>\', \'error\');
            };
        <?php endif; ?>
    </script>
</body>
</html>
