<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}

include ('includes/header.php');

//table name
$table_name = "dns";

//table call
$res = $db->select($table_name, '*', '', '');

//update call
@$resU = $db->select($table_name, '*', 'id = :id', '', [':id' => $_GET['update']]);

if(isset($_POST['submitU'])){
	unset($_POST['submitU']);
	$updateData = $_POST;
	$db->update($table_name, $updateData, 'id = :id',[':id' => $_GET['update']]);
	echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}

//submit new
if (isset($_POST['submit'])){
	unset($_POST['submit']);
	$db->insert($table_name, $_POST);
	$db->close();
	echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}

//delete row
if(isset($_GET['delete'])){
	$db->delete($table_name, 'id = :id',[':id' => $_GET['delete']]);
	echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=2'</script>";
}

//delete modal
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciamento de DNS</title>
    <style>
        :root {
            --primary-black: #000000;
            --dark-red: #8B0000;
            --bright-red: #FF0000;
            --dark-gray: #1a1a1a;
            --light-gray: #f8f9fa;
        }
        
        body {
            background: linear-gradient(135deg, var(--primary-black), var(--dark-red));
            background-attachment: fixed;
            color: white;
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }
        
        .page-container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        
        .main-content {
            flex: 1;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            padding-top: 40px;
            padding-bottom: 40px;
        }
        
        .card-custom {
            background: rgba(0, 0, 0, 0.7);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(255, 0, 0, 0.2);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 0, 0, 0.2);
            overflow: visible;
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .card-header-custom {
            background: linear-gradient(90deg, var(--primary-black), var(--dark-red));
            padding: 20px;
            border-bottom: 2px solid var(--bright-red);
        }
        
        .card-body-custom {
            padding: 30px;
        }
        
        .form-control {
            background-color: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 0, 0, 0.3);
            color: white;
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s;
            height: auto;
            min-height: 45px;
            width: 100%;
        }
        
        .form-control:focus {
            background-color: rgba(255, 255, 255, 0.15);
            border-color: var(--bright-red);
            box-shadow: 0 0 0 0.2rem rgba(255, 0, 0, 0.25);
            color: white;
        }
        
        .form-label {
            font-weight: 600;
            color: #f8f9fa;
            margin-bottom: 8px;
            display: block;
        }
        
        .btn-custom {
            background: linear-gradient(45deg, var(--primary-black), var(--dark-red));
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: bold;
            color: white;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(255, 0, 0, 0.2);
            margin-top: 15px;
            display: inline-block;
            text-decoration: none;
            text-align: center;
        }
        
        .btn-custom:hover {
            background: linear-gradient(45deg, var(--dark-red), var(--primary-black));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 0, 0, 0.3);
            color: white;
            text-decoration: none;
        }
        
        .btn-info-custom {
            background: linear-gradient(45deg, #007bff, #0056b3);
        }
        
        .btn-danger-custom {
            background: linear-gradient(45deg, #dc3545, #a71d2a);
        }
        
        h2, h3 {
            font-weight: 700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
        }
        
        .emoji {
            font-size: 1.2em;
            margin-right: 8px;
        }
        
        .table-custom {
            width: 100%;
            border-collapse: collapse;
            margin: 25px 0;
            font-size: 0.9em;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
        }
        
        .table-custom thead tr {
            background: linear-gradient(90deg, var(--primary-black), var(--dark-red));
            color: #ffffff;
            text-align: left;
        }
        
        .table-custom th,
        .table-custom td {
            padding: 12px 15px;
            border-bottom: 1px solid rgba(255, 0, 0, 0.2);
        }
        
        .table-custom tbody tr {
            background-color: rgba(0, 0, 0, 0.5);
        }
        
        .table-custom tbody tr:last-of-type {
            border-bottom: 2px solid var(--bright-red);
        }
        
        .table-custom tbody tr:hover {
            background-color: rgba(255, 0, 0, 0.1);
        }
        
        .action-buttons {
            display: flex;
            gap: 10px;
        }
        
        .action-btn {
            padding: 6px 12px;
            border-radius: 5px;
            color: white;
            text-decoration: none;
            transition: all 0.3s;
        }
        
        .action-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            color: white;
            text-decoration: none;
        }
        
        .btn-edit {
            background: linear-gradient(45deg, #007bff, #0056b3);
        }
        
        .btn-delete {
            background: linear-gradient(45deg, #dc3545, #a71d2a);
        }
        
        /* Modal styles */
        .modal-content {
            background: rgba(0, 0, 0, 0.8);
            border: 1px solid rgba(255, 0, 0, 0.3);
            border-radius: 15px;
            color: white;
        }
        
        .modal-header {
            background: linear-gradient(90deg, var(--primary-black), var(--dark-red));
            border-bottom: 1px solid var(--bright-red);
        }
        
        .modal-footer {
            border-top: 1px solid rgba(255, 0, 0, 0.3);
        }
        
        .btn-default {
            background: linear-gradient(45deg, #6c757d, #495057);
            color: white;
            border: none;
        }
        
        .btn-default:hover {
            background: linear-gradient(45deg, #495057, #343a40);
            color: white;
        }
        
        /* Responsividade para dispositivos móveis */
        @media (max-width: 992px) {
            .card-custom {
                max-width: 95%;
            }
            
            .table-custom {
                font-size: 0.85em;
            }
            
            .table-custom th,
            .table-custom td {
                padding: 10px 12px;
            }
        }
        
        @media (max-width: 768px) {
            .main-content {
                padding: 15px;
                padding-top: 20px;
                padding-bottom: 20px;
            }
            
            .card-body-custom {
                padding: 20px;
            }
            
            .card-header-custom {
                padding: 15px;
            }
            
            h2 {
                font-size: 1.5rem;
            }
            
            h3 {
                font-size: 1.3rem;
            }
            
            .btn-custom {
                padding: 10px 20px;
                margin: 10px 5px;
            }
            
            .table-responsive {
                overflow-x: auto;
            }
            
            .table-custom {
                font-size: 0.8em;
            }
            
            .table-custom th,
            .table-custom td {
                padding: 8px 10px;
            }
            
            .action-buttons {
                flex-direction: column;
                gap: 5px;
            }
            
            .action-btn {
                padding: 5px 8px;
                font-size: 0.9em;
                text-align: center;
            }
        }
        
        @media (max-width: 576px) {
            .card-body-custom {
                padding: 15px;
            }
            
            .form-control {
                padding: 10px;
            }
            
            .btn-custom {
                width: 100%;
                margin: 5px 0;
            }
            
            .table-custom {
                font-size: 0.75em;
            }
            
            .table-custom th,
            .table-custom td {
                padding: 6px 8px;
            }
            
            .emoji {
                font-size: 1.1em;
                margin-right: 5px;
            }
        }
    </style>
</head>
<body>
<div class="page-container">

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2><span class="emoji">⚠️</span> Confirmar</h2>
            </div>
            <div class="modal-body">
                Tem certeza que deseja excluir este DNS?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                <a class="btn btn-danger btn-ok">Excluir</a>
            </div>
        </div>
    </div>
</div>

<?php
if (isset($_GET['create'])){

//create form
?>
<div class="main-content">
    <div class="card-custom">
        <div class="card-header-custom text-center">
            <h2><span class="emoji">🌐</span> Gerenciamento de DNS</h2>
        </div>
        
        <div class="card-body-custom">
            <div class="mb-4">
                <h3><span class="emoji">➕</span> Criar DNS</h3>
            </div>
            <form method="post">
                <div class="form-group">
                    <label class="form-label" for="title"><span class="emoji">🏷️</span> Título</label>
                    <input class="form-control" id="title" name="title" placeholder="Título do DNS" type="text" required/>
                </div>
                <div class="form-group">
                    <label class="form-label" for="dns"><span class="emoji">🔗</span> URL do DNS</label>
                    <input class="form-control" id="url" name="url" placeholder="URL do DNS (ex: https://exemplo.com)" type="text" required/>
                </div>
                <div class="form-group text-center">
                    <button class="btn btn-custom" name="submit" type="submit">
                        <span class="emoji">💾</span> Salvar
                    </button>
                    <a href="./<?=basename($_SERVER["SCRIPT_NAME"]) ?>" class="btn btn-custom btn-danger-custom">
                        <span class="emoji">↩️</span> Voltar
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<?php 
}else if (isset($_GET['update'])){ 

//update form
?>
<div class="main-content">
    <div class="card-custom">
        <div class="card-header-custom text-center">
            <h2><span class="emoji">🌐</span> Gerenciamento de DNS</h2>
        </div>
        
        <div class="card-body-custom">
            <div class="mb-4">
                <h3><span class="emoji">✏️</span> Editar DNS</h3>
            </div>
            <form method="post">
                <div class="form-group">
                    <label class="form-label" for="title"><span class="emoji">🏷️</span> Título</label>
                    <input class="form-control" id="title" name="title" placeholder="Título do DNS" value="<?=$resU[0]['title'] ?>" type="text" required/>
                </div>
                <div class="form-group">
                    <label class="form-label" for="dns"><span class="emoji">🔗</span> URL do DNS</label>
                    <input class="form-control" id="url" name="url" placeholder="URL do DNS (ex: https://exemplo.com)" value="<?=$resU[0]['url'] ?>" type="text" required/>
                </div>
                <div class="form-group text-center">
                    <button class="btn btn-custom" name="submitU" type="submit">
                        <span class="emoji">💾</span> Atualizar
                    </button>
                    <a href="./<?=basename($_SERVER["SCRIPT_NAME"]) ?>" class="btn btn-custom btn-danger-custom">
                        <span class="emoji">↩️</span> Voltar
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
 }else{
//main table/form
	 ?>
<div class="main-content">
    <div class="card-custom">
        <div class="card-header-custom text-center">
            <h2><span class="emoji">🌐</span> Gerenciamento de DNS</h2>
        </div>

        <div class="card-body-custom">
            <div class="text-center mb-4">
                <a href="./<?=basename($_SERVER["SCRIPT_NAME"]) ?>?create" class="btn btn-custom">
                    <span class="emoji">➕</span> Novo DNS
                </a>
            </div>
            
            <div class="table-responsive">
                <table class="table-custom">
                    <thead>
                        <tr>
                            <th><span class="emoji">#</span> ID</th>
                            <th><span class="emoji">🏷️</span> Título</th>
                            <th><span class="emoji">🔗</span> URL</th>
                            <th><span class="emoji">⚙️</span> Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($res as $row) {?>
                        <tr>
                            <td><?=$row['id'] ?></td>
                            <td><?=$row['title'] ?></td>
                            <td><?=$row['url'] ?></td>
                            <td>
                                <div class="action-buttons">
                                    <a class="action-btn btn-edit" href="./<?=basename($_SERVER["SCRIPT_NAME"]) ?>?update=<?=$row['id'] ?>">
                                        <span class="emoji">✏️</span> Editar
                                    </a>
                                    <a class="action-btn btn-delete" href="#" data-href="./<?=basename($_SERVER["SCRIPT_NAME"]) ?>?delete=<?=$row['id'] ?>" data-toggle="modal" data-target="#confirm-delete">
                                        <span class="emoji">🗑️</span> Excluir
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php }?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php }?>

<?php include ('includes/footer.php');?>

<script>
    $('#confirm-delete').on('show.bs.modal', function(e) {
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
    });
</script>

</div>
</body>
</html>