<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}

include ('includes/header.php');

$table_name = "chatbot_slc_max";

$res = $db->select($table_name, '*', '', 'id DESC LIMIT 1');

$dns_list = $db->select('dns', 'id, title, url', '', 'title ASC');

if (isset($_POST['submit'])) {
    unset($_POST['submit']);

    $data = [
        'chatbot_link' => $_POST['chatbot_link'],
        'dns_id' => $_POST['dns_id'],
        'status' => $_POST['status']
    ];

    if (empty($res)) {
        $db->insert($table_name, $data);
    } else {
        $db->update($table_name, $data, 'id = :id', [':id' => $res[0]['id']]);
    }

    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuração do Chatbot</title>
    <style>
        :root {
            --primary-black: #000000;
            --dark-red: #8B0000;
            --bright-red: #FF0000;
            --dark-gray: #1a1a1a;
            --light-gray: #f8f9fa;
        }
        
        body {
            background: linear-gradient(135deg, var(--primary-black), var(--dark-red));
            background-attachment: fixed;
            color: white;
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }
        
        .page-container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        
        .main-content {
            flex: 1;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            padding-top: 40px;
            padding-bottom: 40px;
        }
        
        .card-custom {
            background: rgba(0, 0, 0, 0.7);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(255, 0, 0, 0.2);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 0, 0, 0.2);
            overflow: visible;
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .card-header-custom {
            background: linear-gradient(90deg, var(--primary-black), var(--dark-red));
            padding: 20px;
            border-bottom: 2px solid var(--bright-red);
        }
        
        .card-body-custom {
            padding: 30px;
        }
        
        .form-control {
            background-color: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 0, 0, 0.3);
            color: white;
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s;
            height: auto;
            min-height: 45px;
            width: 100%;
        }
        
        .form-control:focus {
            background-color: rgba(255, 255, 255, 0.15);
            border-color: var(--bright-red);
            box-shadow: 0 0 0 0.2rem rgba(255, 0, 0, 0.25);
            color: white;
        }
        
        /* Estilo específico para selects */
        select.form-control {
            height: auto;
            padding: 10px 15px;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='white'%3e%3cpath d='M7 10l5 5 5-5z'/%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: right 10px center;
            background-size: 16px;
            padding-right: 40px;
        }
        
        .form-label {
            font-weight: 600;
            color: #f8f9fa;
            margin-bottom: 8px;
            display: block;
        }
        
        .btn-custom {
            background: linear-gradient(45deg, var(--primary-black), var(--dark-red));
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: bold;
            color: white;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(255, 0, 0, 0.2);
            margin-top: 15px;
        }
        
        .btn-custom:hover {
            background: linear-gradient(45deg, var(--dark-red), var(--primary-black));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 0, 0, 0.3);
        }
        
        h2, h3 {
            font-weight: 700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
        }
        
        .emoji {
            font-size: 1.2em;
            margin-right: 8px;
        }
        
        select option {
            background-color: var(--dark-gray);
            color: white;
            padding: 10px;
        }
        
        /* Garantir que o texto dentro dos selects seja visível */
        select.form-control option {
            padding: 12px;
            font-size: 16px;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        /* Responsividade para dispositivos móveis */
        @media (max-width: 768px) {
            .main-content {
                padding: 15px;
                padding-top: 20px;
                padding-bottom: 20px;
            }
            
            .card-body-custom {
                padding: 20px;
            }
            
            .card-header-custom {
                padding: 15px;
            }
            
            h2 {
                font-size: 1.5rem;
            }
            
            h3 {
                font-size: 1.3rem;
            }
            
            .btn-custom {
                padding: 10px 20px;
                width: 100%;
            }
        }
        
        @media (max-width: 576px) {
            .card-body-custom {
                padding: 15px;
            }
            
            .form-control {
                padding: 10px;
            }
            
            select.form-control {
                padding-right: 35px;
                background-position: right 8px center;
            }
        }
    </style>
</head>
<body>
<div class="page-container">
    <div class="main-content">
        <div class="card-custom">
            <div class="card-header-custom text-center">
                <h2><span class="emoji">🤖</span> Chatbot</h2>
            </div>

            <div class="card-body-custom">
                <div class="mb-4">
                    <h3><span class="emoji">⚙️</span> Ajustes Chatbot</h3>
                </div>
                <form method="post">
                    <div class="form-group">
                        <label class="form-label" for="chatbot_link"><span class="emoji">🔗</span> Link do Chatbot</label>
                        <input class="form-control" name="chatbot_link" type="text" 
                               placeholder="https://example.com/chatbot" 
                               value="<?= $res[0]['chatbot_link'] ?? '' ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="dns_id"><span class="emoji">🌐</span> Selecionar DNS</label>
                        <select class="form-control" name="dns_id" required>
                            <option value="">Selecione uma DNS</option>
                            <?php foreach ($dns_list as $dns): ?>
                                <option value="<?= $dns['id'] ?>" 
                                    <?= isset($res[0]['dns_id']) && $res[0]['dns_id'] == $dns['id'] ? 'selected' : '' ?>>
                                    <?= $dns['title'] ?> (<?= $dns['url'] ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="status"><span class="emoji">📊</span> Status do Chatbot</label>
                        <select class="form-control" name="status" required>
                            <option value="Ativo" <?= isset($res[0]['status']) && $res[0]['status'] == 'Ativo' ? 'selected' : '' ?>>Ativo ✅</option>
                            <option value="Desativado" <?= isset($res[0]['status']) && $res[0]['status'] == 'Desativado' ? 'selected' : '' ?>>Desativado ❌</option>
                        </select>
                    </div>
                    
                    <div class="form-group text-center">
                        <button class="btn btn-custom" name="submit" type="submit">
                            <span class="emoji">💾</span> Salvar Configurações
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>
</body>
</html>